<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
  <xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
  <xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
  <!-- Least Squares Report -->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <!-- Title displayed in browser Title Bar -->
        <title lang="en">Výpis Vyrovnání metodou nejmenších čtverců</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <xsl:for-each select="AdjustmentNet">
                <center>
                  <!-- Report Title -->
                  <h2 lang="en">Výpis Vyrovnání metodou nejmenších čtverců</h2>
                  <p lang="en">
                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                  </p>
                </center>
                <p lang="en" style="text-align:center;font-size:80%">
                  <strong>Aktivní geografický systém:&#xa0;</strong>
                  &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                  &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                  <xsl:if test="//@linearUnits = 'I'">, stopy</xsl:if>
                  <xsl:if test="//@linearUnits = 'F'">, Survey stopy</xsl:if>
                  <xsl:if test="//@linearUnits = 'M'">, metry</xsl:if>
                </p>
                <hr/>
                <xsl:for-each select="LeastSquaresVýchozís">
                  <center>
                    <h4>Metoda nejmenších čtverců Výchozí</h4>
                  </center>
                  <hr size="1px"/>
                  <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                    <tbody>
                      <tr>
                        <th align="left" nowrap="nowrap">Kombinovaný koeficient měřítka:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="//@combinedScaleFactorOption"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Kombinovaný koeficient měřítka:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="cif:distanceFormat(number(//@combinedScaleFactorValue))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Zobrazovat chyby v Okně zpráv:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="//@displayErrorInMessageCenter"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro Koeficient vzdálenosti:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addDistConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro Vzdálenost PPM:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addDistPpm))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro směrový úhel:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addHorzAngle))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro azimut:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addAzimuth))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro koeficient Trig výšku:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addTrigLevConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro Trig výšku PPM:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addTrigLevPpm))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Doplněk pro koeficient rozdílu výšky:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@addDiffLevConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí vzdálenost pro koeficient odhadu chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errDistConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí vzdálenost PPM:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errDistPpm))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí Směrový úhel odhad chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errHorzAngle))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí Azimut Odhad chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errAzimuth))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí koeficient Trig výška Odhad chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errTrigLevConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výchozí koeficient Rozdíl výšek Odhad chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@errDiffLevConst))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Délková tolerance:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@tolDistance))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Úhlová tolerance:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@tolAngle))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výšková tolerance:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@tolElevation))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Chyba nastavení:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@setupError))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">XYZ počet des. míst:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@xyzDecPlaces"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Použít opakování chyb PLUS doplněk pro odhad chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@error"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výpočet souřadnic Standardní chyba a chyba elipsy:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@computeCoord"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výpočet zakřivní země a atmosférická refrakce:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@earthCurvature"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Úhly vyvážení:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@angleBalance"/>
                        </td>
                      </tr>
                      <tr>
                        <td>&#xa0;</td>
                      </tr>
                    </tbody>
                  </table>
                </xsl:for-each>
                <xsl:for-each select="ReportHeader">
                  <hr size="1px"/>
                  <center>
                    <h4>Celkem</h4>
                  </center>
                  <hr size="1px"/>
                  <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                    <tbody>
                      <tr>
                        <th align="left">
                          <xsl:choose>
                            <xsl:when test="//@adjustmentConverges='true'">Metoda nejmenších čtverců konvergovala.</xsl:when>
                            <xsl:otherwise>Metoda nejmenších čtverců nekonvergovala.</xsl:otherwise>
                          </xsl:choose>
                        </th>
                      </tr>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Počet testů:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="//@numberOfBenchMarks"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Počet stanic:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="//@numberOfStations"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Počet měření:&#xa0;</th>
                        <td align="left" nowrap="nowrap">
                          <xsl:value-of select="//@numberOfMeasurements"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Počet potřebných výrazů pro normálové rovnice:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@numberOfRequiredTermsForNormalEquations"/>
                        </td>
                      </tr>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Směrově stupně volnosti:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@horizDegreesOfFreedom"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Spodní Směrově chi-čtverec 5% úroveň:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@horizChiLower))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Směrově standardní chyba jednotek váhy:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@horizStandardErrorOfUnitWeight))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Horní Směrově chi-čtverec 5% úroveň:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@horizChiUpper))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Směrově 95% spolehlivost F statistický násobek chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@horizConfidenceStatisticMultiplier))"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:choose>
                          <xsl:when test="//@horizChiPassed='upper'">
                            <th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
                              Upozornění! Směrově test Chi-čtverce překročil horní hranici
                            </th>
                          </xsl:when>
                          <xsl:when test="//@horizChiPassed='lower'">
                            <th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
                              Upozornění! Směrově test Chi-čtverce překročil spodní hranici
                            </th>

                          </xsl:when>
                          <xsl:when test="//@horizChiPassed='passed'">
                            <th align="left" colspan="2" nowrap="nowrap">
                              Směrově test Chi-čtverce vyhověl
                            </th>
                          </xsl:when>
                        </xsl:choose>

                      </tr>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výškově stupně volnosti:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="//@levelDegreesOfFreedom"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Spodní Výškově Chi-čtverec 5% úroveň:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@levelChiLower))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výškově standardní chyba váhy jednotek:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@levelStandardErrorOfUnitWeight))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Horní Výškově Chi-čtverec 5% úroveň:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@levelChiUpper))"/>
                        </td>
                      </tr>
                      <tr>
                        <th align="left" nowrap="nowrap">Výškově 95% spolehlivost F statistický násobek chyby:&#xa0;</th>
                        <td align="left">
                          <xsl:value-of select="cif:distanceFormat(number(//@levelConfidenceStatisticMultiplier))"/>
                        </td>
                      </tr>
                      <tr>
                        <xsl:choose>
                          <xsl:when test="//@levelChiPassed='upper'">
                            <th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
                              Upozornění! Výškově Chi-čtverec test překročil horní hranici
                            </th>
                          </xsl:when>
                          <xsl:when test="//@levelChiPassed='lower'">
                            <th align="left" colspan="2" nowrap="nowrap" style="color:FF0000">
                              Upozornění! Výškově Chi-čtverec test překročil spodní hranici
                            </th>

                          </xsl:when>
                          <xsl:when test="//@levelChiPassed='passed'">
                            <th align="left" colspan="2" nowrap="nowrap">
                              Výškově test Chi-čtverce vyhověl
                            </th>
                          </xsl:when>
                        </xsl:choose>
                      </tr>
                      <tr>
                        <td>&#xa0;</td>
                      </tr>
                    </tbody>
                  </table>
                </xsl:for-each>
                <!-- Observation Data -->
                <hr size="1px"/>
                <center>
                  <h4>Nastavení</h4>
                </center>
                <hr size="1px"/>
                <xsl:for-each select="GenFileReport">
                  <xsl:for-each select="GenFileSetupList">
                    <tr style="line-height:50%">
                      <td>&#xa0;</td>
                    </tr>
                    <table class="margin" cellpadding="1" cellspacing="1" width="25%">
                      <tbody>
                        <tr>
                          <th align="left" nowrap="nowrap">Nastavení provádění #&#xa0;</th>
                          <td align="left" nowrap="nowrap">
                            <xsl:value-of select="@setupNumber"/>
                          </td>
                          <th align="left" nowrap="nowrap">ve stanici:&#xa0;</th>
                          <td align="left" nowrap="nowrap">
                            <xsl:value-of select="@stationName"/>
                          </td>
                        </tr>
                        <tr style="line-height:50%">
                          <td>&#xa0;</td>
                        </tr>
                        <tr>
                          <th align="left" nowrap="nowrap">Směrově kolimace sekund:&#xa0;</th>
                          <td align="left" nowrap="nowrap">
                            <xsl:choose>
                              <xsl:when test="@horizontalCollimationSeconds='*******'">
                                <xsl:value-of select="@horizontalCollimationSeconds"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@horizontalCollimationSeconds))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </td>
                          <th align="left" nowrap="nowrap">Výškově kolimace sekund:&#xa0;</th>
                          <td align="left" nowrap="nowrap">
                            <xsl:choose>
                              <xsl:when test="@verticalCollimationSeconds='*******'">
                                <xsl:value-of select="@verticalCollimationSeconds"/>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="cif:distanceFormat(number(@verticalCollimationSeconds))"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </td>
                        </tr>
                        <xsl:for-each select="MultiPoint">
                          <xsl:for-each select="MultiPointList">
                            <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                              <tbody>
                                <xsl:choose>
                                  <xsl:when test="@isAsterisk='True'">
                                    <tr style="color:FF0000">
                                      <th align="left" nowrap="nowrap">Opakovaná chyba u více bodů ve stanici:&#xa0;</th>
                                      <td align="left" nowrap="nowrap">
                                        <xsl:value-of select="@multiPointStationName"/>
                                      </td>
                                      <th align="left" nowrap="nowrap">je:&#xa0;</th>
                                      <td align="right" nowrap="nowrap">
                                        <xsl:choose>
                                          <xsl:when test="@multiPointError='*******'">
                                            <xsl:value-of select="@multiPointError"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="cif:distanceFormat(number(@multiPointError))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </td>
                                      <td align="left">*</td>
                                    </tr>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <tr>
                                      <th align="left" nowrap="nowrap">Opakovaná chyba u více bodů ve stanici:&#xa0;</th>
                                      <td align="left" nowrap="nowrap">
                                        <xsl:value-of select="@multiPointStationName"/>
                                      </td>
                                      <th align="left" nowrap="nowrap">je:&#xa0;</th>
                                      <td align="right" nowrap="nowrap">
                                        <xsl:choose>
                                          <xsl:when test="@multiPointError='*******'">
                                            <xsl:value-of select="@multiPointError"/>
                                          </xsl:when>
                                          <xsl:otherwise>
                                            <xsl:value-of select="cif:distanceFormat(number(@multiPointError))"/>
                                          </xsl:otherwise>
                                        </xsl:choose>
                                      </td>
                                    </tr>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </tbody>
                            </table>
                          </xsl:for-each>
                        </xsl:for-each>
                      </tbody>
                    </table>
                    <xsl:for-each select="DistanceStandardDeviation">
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">OPAKOVÁNÍ STANDARDNÍCH CHYB&#xa0;</th>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                        <colgroup span="9">
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                          <col width="10%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">
                              Pozorovaná<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Std. odch.
                            </th>
                            <th class="underline" lang="en" align="right">
                              Vodor. vzd.<br/>SD (střední)
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Max. rozpětí
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Std. odch.
                            </th>
                            <th class="underline" lang="en" align="right">
                              Výšk. rozdíl<br/>SD (střední)
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Max. rozpětí
                            </th>
                            <th class="underline" lang="en" align="right">
                              Porovnání<br/>Směr. vdt.
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Výšk. rozdíl
                            </th>
                          </tr>
                        </thead>
                      </table>
                      <tbody>
                        <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                          <xsl:for-each select="DistanceStandardDeviationList">
                            <xsl:choose>
                              <xsl:when test="@isAsterisk='True' or @isAsteriskElv='True' or @isAsteriskHD='True' or @isAsteriskED='True'">
                                <tr style="color:FF0000">
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="@distanceStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceStandardDeviation='*******'">
                                        <xsl:value-of select="@distanceStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceStandardDeviationMean='*******'">
                                        <xsl:value-of select="@distanceStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceMaximumSpread='*******'">
                                        <xsl:value-of select="@distanceMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationStandardDeviation='*******'">
                                        <xsl:value-of select="@elevationStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationStandardDeviationMean='*******'">
                                        <xsl:value-of select="@elevationStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationMaximumSpread='*******'">
                                        <xsl:value-of select="@elevationMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@compareHorizontalDistance='*******'">
                                        <xsl:value-of select="@compareHorizontalDistance"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@compareHorizontalDistance))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@compareElevationDifference='*******'">
                                        <xsl:value-of select="@compareElevationDifference"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@compareElevationDifference))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="left">*</td>
                                </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                <tr>
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="@distanceStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceStandardDeviation='*******'">
                                        <xsl:value-of select="@distanceStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceStandardDeviationMean='*******'">
                                        <xsl:value-of select="@distanceStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@distanceMaximumSpread='*******'">
                                        <xsl:value-of select="@distanceMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@distanceMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationStandardDeviation='*******'">
                                        <xsl:value-of select="@elevationStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationStandardDeviationMean='*******'">
                                        <xsl:value-of select="@elevationStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@elevationMaximumSpread='*******'">
                                        <xsl:value-of select="@elevationMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@elevationMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@compareHorizontalDistance='*******'">
                                        <xsl:value-of select="@compareHorizontalDistance"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@compareHorizontalDistance))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@compareElevationDifference='*******'">
                                        <xsl:value-of select="@compareElevationDifference"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@compareElevationDifference))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                </tr>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:for-each>
                        </table>
                      </tbody>
                    </xsl:for-each>
                    <xsl:for-each select="AngleStandardDeviation">
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">OPAKOVÁNÍ STANDARDNÍCH CHYB PRO ÚHLY&#xa0;</th>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                        <colgroup span="5">
                          <col width="15%"/>
                          <col width="15%"/>
                          <col width="15%"/>
                          <col width="15%"/>
                          <col width="15%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">
                              Zpětná<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="left">
                              Dopředná<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Std. odch.
                            </th>
                            <th class="underline" lang="en" align="right">
                              Std. odch.<br/>(Mean)
                            </th>
                            <th class="underline" lang="en" align="right">
                              <br/>Max. rozpětí
                            </th>
                          </tr>
                        </thead>
                      </table>
                      <tbody>
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <xsl:for-each select="AngleStandardDeviationList">
                            <xsl:choose>
                              <xsl:when test="@isAsterisk='True'">
                                <tr style="color:FF0000">
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="@backSightStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:value-of select="@foreSightStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleStandardDeviation='*******'">
                                        <xsl:value-of select="@angleStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleStandardDeviationMean='*******'">
                                        <xsl:value-of select="@angleStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleMaximumSpread='*******'">
                                        <xsl:value-of select="@angleMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="left">*</td>
                                </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                <tr>
                                  <td align="left" nowrap="nowrap">
                                    <xsl:value-of select="@backSightStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:value-of select="@foreSightStationName"/>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleStandardDeviation='*******'">
                                        <xsl:value-of select="@angleStandardDeviation"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviation))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleStandardDeviationMean='*******'">
                                        <xsl:value-of select="@angleStandardDeviationMean"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviationMean))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                  <td align="right" nowrap="nowrap">
                                    <xsl:choose>
                                      <xsl:when test="@angleMaximumSpread='*******'">
                                        <xsl:value-of select="@angleMaximumSpread"/>
                                      </xsl:when>
                                      <xsl:otherwise>
                                        <xsl:value-of select="cif:distanceFormat(number(@angleMaximumSpread))"/>
                                      </xsl:otherwise>
                                    </xsl:choose>
                                  </td>
                                </tr>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:for-each>
                        </table>
                      </tbody>
                    </xsl:for-each>
                  </xsl:for-each>
                  <tr style="line-height:50%">
                    <td>&#xa0;</td>
                  </tr>
                  <hr size="1px"/>
                  <center>
                    <h4>Přípravné uzavření trasy dle pravidel Compass</h4>
                  </center>
                  <hr size="1px"/>
                  <xsl:for-each select="GenFileTraverseList">
                    <xsl:for-each select="Traverse">
                      <table class="margin" cellpadding="1" cellspacing="1" width="35%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">VÝPIS PŘÍPRAVNÉHO UZAVŘENÍ TRASY&#xa0;</th>
                          </tr>
                          <tr>
                            <th align="left" nowrap="nowrap">PŘÍPRAVNÁ DÉLKOVÁ CHYBA UZAVŘENÍ JE &#xa0;</th>
                            <td align="left" nowrap="nowrap">
                              <xsl:value-of select="cif:distanceFormat(number(@linearClosureError))"/>
                            </td>
                            <th align="left" nowrap="nowrap">PŘESNOST JE 1/ &#xa0;</th>
                            <td align="left" nowrap="nowrap">
                              <xsl:value-of select="cif:distanceFormat(number(@precision))"/>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <colgroup span="3">
                          <col width="5%"/>
                          <col width="5%"/>
                          <col width="5%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">Stanice</th>
                            <th class="underline" lang="en" align="right">Y</th>
                            <th class="underline" lang="en" align="right">X</th>
                          </tr>
                        </thead>
                        <tbody>
                          <xsl:for-each select="TraverseList">
                            <tr>
                              <td align="left">
                                <xsl:value-of select="@stationName"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </tbody>
                      </table>
                    </xsl:for-each>
                    <tr style="line-height:50%">
                      <td>&#xa0;</td>
                    </tr>
                    <xsl:for-each select="AdjustedHorizontal">
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">PŘÍPRAVNÉ GENEROVANÉ SOUŘADNICE&#xa0;</th>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <colgroup span="3">
                          <col width="5%"/>
                          <col width="5%"/>
                          <col width="5%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">Stanice</th>
                            <th class="underline" lang="en" align="right">Y</th>
                            <th class="underline" lang="en" align="right">X</th>
                          </tr>
                        </thead>
                        <tbody>
                          <xsl:for-each select="AdjustedHorizontalList">
                            <tr>
                              <td align="left">
                                <xsl:value-of select="@stationName"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                              </td>
                              <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </tbody>
                      </table>
                    </xsl:for-each>
                    <tr style="line-height:50%">
                      <td>&#xa0;</td>
                    </tr>
                    <xsl:for-each select="DistanceResidual">
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">PŘÍPRAVNÉ DÉLKY ZBYTKY&#xa0;</th>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <colgroup span="3">
                          <col width="5%"/>
                          <col width="5%"/>
                          <col width="5%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">
                              Ze<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="left">
                              Do<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="right">Zbytek</th>
                          </tr>
                        </thead>
                        <tbody>
                          <xsl:for-each select="DistanceResidualList">
                            <tr>
                              <td align="left">
                                <xsl:value-of select="@fromStation"/>
                              </td>
                              <td align="left">
                                <xsl:value-of select="@toStation"/>
                              </td>
                              <td align="right">
                                <xsl:choose>
                                  <xsl:when test="@residual='*******'">
                                    <xsl:value-of select="@residual"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </tbody>
                      </table>
                    </xsl:for-each>
                    <tr style="line-height:50%">
                      <td>&#xa0;</td>
                    </tr>
                    <xsl:for-each select="AngleResidual">
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <tbody>
                          <tr>
                            <th align="left" nowrap="nowrap">PŘÍPRAVNÉ ÚHLY ZBYTKOVÉ&#xa0;</th>
                          </tr>
                        </tbody>
                      </table>
                      <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                        <colgroup span="4">
                          <col width="5%"/>
                          <col width="5%"/>
                          <col width="5%"/>
                          <col width="5%"/>
                        </colgroup>
                        <thead style="display:table-header-group">
                          <tr>
                            <th class="underline" lang="en" align="left">
                              Zpětná<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="left">
                              Nastavená<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="left">
                              Dopředná<br/>stanice
                            </th>
                            <th class="underline" lang="en" align="right">Zbytek</th>
                          </tr>
                        </thead>
                        <tbody>
                          <xsl:for-each select="AngleResidualList">
                            <tr>
                              <td align="left">
                                <xsl:value-of select="@backSightStation"/>
                              </td>
                              <td align="left">
                                <xsl:value-of select="@setupStation"/>
                              </td>
                              <td align="left">
                                <xsl:value-of select="@foreSightStation"/>
                              </td>
                              <td align="right">
                                <xsl:choose>
                                  <xsl:when test="@residual='*******'">
                                    <xsl:value-of select="@residual"/>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </td>
                            </tr>
                          </xsl:for-each>
                        </tbody>
                      </table>
                    </xsl:for-each>
                  </xsl:for-each>
                </xsl:for-each>
                <tr style="line-height:50%">
                  <td>&#xa0;</td>
                </tr>
                <hr size="1px"/>
                <center>
                  <h4>Výškové metoda nejmenších čtverců</h4>
                </center>
                <hr size="1px"/>
                <xsl:for-each select="OneDFileReport">
                  <xsl:for-each select="OneDFileReportList">
                    <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <xsl:for-each select="ElevationDifference">
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">CHYBNÉ UZAVŘENÍ VÍCE VÝŠEK MĚŘENÉ ROZDÍLY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <colgroup span="3">
                            <col width="20%"/>
                            <col width="20%"/>
                            <col width="20%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Ze<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Do<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="right">Chyba uzavření</th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="ElevationDifferenceList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@misClosure='*******'">
                                          <xsl:value-of select="@misClosure"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@misClosure))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@misClosure='*******'">
                                          <xsl:value-of select="@misClosure"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@misClosure))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>

                      <xsl:for-each select="BenchMarkElevationResiduals">
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">TEST ZBYTEK VÝŠKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <colgroup span="5">
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">Stanice</th>
                              <th class="underline" lang="en" align="right">
                                Vstupní<br/>Výška
                              </th>
                              <th class="underline" lang="en" align="right">
                                Vyrovnaná<br/>Výška
                              </th>
                              <th class="underline" lang="en" align="right">Zbytek</th>
                              <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                              <th class="underline" lang="en" align="right">
                                Chyba<br/>Odhad
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="BenchMarkElevationResidualsList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@stationName"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@inputElevation='*******'">
                                          <xsl:value-of select="@inputElevation"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:ordinateFormat(number(@inputElevation))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@adjustedElevation='*******'">
                                          <xsl:value-of select="@adjustedElevation"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@errorEstimate='*******'">
                                          <xsl:value-of select="@errorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@stationName"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@inputElevation='*******'">
                                          <xsl:value-of select="@inputElevation"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:ordinateFormat(number(@inputElevation))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@adjustedElevation='*******'">
                                          <xsl:value-of select="@adjustedElevation"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@errorEstimate='*******'">
                                          <xsl:value-of select="@errorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>

                      <xsl:for-each select="BenchMarkStats">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">TEST RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                              </td>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">MAX. TEST RMS CHYBA VE STANICI  &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@stationName"/>
                              </td>
                              <th align="left" nowrap="nowrap"> z &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>

                      <xsl:for-each select="LevelDifferenceResiduals">
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">VÝŠK. ROZDÍL ZBYTKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <colgroup span="5">
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Ze<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Do<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="right">Měřená</th>
                              <th class="underline" lang="en" align="right">Zbytek</th>
                              <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                              <th class="underline" lang="en" align="right">
                                Chyba<br/>Odhad
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="LevelDifferenceResidualsList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@measured='*******'">
                                          <xsl:value-of select="@measured"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@measured))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@errorEstimate='*******'">
                                          <xsl:value-of select="@errorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@measured='*******'">
                                          <xsl:value-of select="@measured"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@measured))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@errorEstimate='*******'">
                                          <xsl:value-of select="@errorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@errorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>

                      <xsl:for-each select="LevelDifferenceStats">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">VÝŠK. ROZDÍL RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                              </td>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">MAX. VÝŠK. ROZDÍL ZBYTEK VE STANICI &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@fromStation"/>
                              </td>
                              <th align="left" nowrap="nowrap"> - &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@toStation"/>
                              </td>
                              <th align="left" nowrap="nowrap"> Z &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>

                      <xsl:for-each select="AdjustedElevations">
                        <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">VYROVNANÉ VÝŠKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                          <colgroup span="3">
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">Stanice</th>
                              <th class="underline" lang="en" align="right">
                                Vyrovnaná<br/>výška
                              </th>
                              <th class="underline" lang="en" align="right">
                                Standardní<br/>chyba
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="AdjustedElevationsList">
                              <tr>
                                <td align="left">
                                  <xsl:value-of select="@stationName"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@adjustedElevation))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@standardError))"/>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>
                    </table>
                  </xsl:for-each>
                </xsl:for-each>
                <tr style="line-height:50%">
                  <td>&#xa0;</td>
                </tr>
                <hr size="1px"/>
                <center>
                  <h4>Směrově Nejmenší čtverce</h4>
                </center>
                <hr size="1px"/>
                <xsl:for-each select="TwoDFileReport">
                  <xsl:for-each select="TwoDFileReportList">
                    <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <xsl:for-each select="AdjustedHorizontal">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">VYROVNÁNÍ SMĚROVĚ&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                          <colgroup span="8">
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">Stanice</th>
                              <th class="underline" lang="en" align="right">Y</th>
                              <th class="underline" lang="en" align="right">X</th>
                              <th class="underline" lang="en" align="right">
                                Standardní chyba<br/>Y
                              </th>
                              <th class="underline" lang="en" align="right">
                                Standardní chyba<br/>X
                              </th>
                              <th class="underline" lang="en" align="right">
                                Elipsa chyby<br/>Hlavní osa
                              </th>
                              <th class="underline" lang="en" align="right">
                                Elipsa chyby<br/>Vedlejší osa
                              </th>
                              <th class="underline" lang="en" align="right">Info. t</th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="AdjustedHorizontalList">
                              <tr>
                                <td align="left">
                                  <xsl:value-of select="@stationName"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@yStandardError))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@xStandardError))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@suErrorEllipse))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@svErrorEllipse))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:angularFormat(number(@infoT))"/>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <xsl:for-each select="HorizontalControlResidual">
                        <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">SMĚROVĚ ŘÍDÍCÍ BOD ZBYTKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                          <colgroup span="5">
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="10%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="10%"/>
                            <col width="15%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">Stanice</th>
                              <th class="underline" lang="en" align="right">
                                Y<br/>Zbytek
                              </th>
                              <th class="underline" lang="en" align="right">
                                Y<br/>Standardizovaný Zbytek
                              </th>
                              <th class="underline" lang="en" align="right">
                                Y<br/>Odhadovaná chyba
                              </th>
                              <th class="underline" lang="en" align="right">
                                X<br/>Zbytek
                              </th>
                              <th class="underline" lang="en" align="right">
                                X<br/>Standardizovaný Zbytek
                              </th>
                              <th class="underline" lang="en" align="right">
                                X<br/>Odhadovaná chyba
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="HorizontalControlResidualList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@stationName"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@xResidual='*******'">
                                          <xsl:value-of select="@yResidual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@yResidual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopErrorY='*******'">
                                          <xsl:value-of select="@snoopErrorY"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopErrorY))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@yErrorEstimate='*******'">
                                          <xsl:value-of select="@yErrorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@yErrorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@xResidual='*******'">
                                          <xsl:value-of select="@yResidual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@xResidual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopErrorX='*******'">
                                          <xsl:value-of select="@snoopErrorX"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopErrorX))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@xErrorEstimate='*******'">
                                          <xsl:value-of select="@xErrorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@xErrorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@stationName"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@yResidual='*******'">
                                          <xsl:value-of select="@yResidual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@yResidual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopErrorT='*******'">
                                          <xsl:value-of select="@snoopErrorY"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopErrorY))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@yErrorEstimate='*******'">
                                          <xsl:value-of select="@yErrorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@yErrorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@xResidual='*******'">
                                          <xsl:value-of select="@xResidual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@xResidual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopErrorX='*******'">
                                          <xsl:value-of select="@snoopErrorX"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopErrorX))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@xErrorEstimate='*******'">
                                          <xsl:value-of select="@xErrorEstimate"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@xErrorEstimate))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>

                      <xsl:for-each select="HorizontalControlStats">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">X řídící RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsErrorX))"/>
                              </td>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek  RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopErrorX))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Max. X zbytek ve stanici &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@stationX"/>
                              </td>
                              <th align="left" nowrap="nowrap"> z &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@residualX))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Y řídící RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsErrorY))"/>
                              </td>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS CHYBA = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopErrorY))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Max. Y zbytek ve stanici &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@stationY"/>
                              </td>
                              <th align="left" nowrap="nowrap"> z &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@residualY))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>

                      <xsl:for-each select="HorizontalDistanceResidual">
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">SMĚROVĚ VZDÁLENOST ZBYTKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                          <colgroup span="5">
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                            <col width="15%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Obsazená<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Pozorovaná<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="right">Vzdálenost</th>
                              <th class="underline" lang="en" align="right">Zbytek</th>
                              <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                              <th class="underline" lang="en" align="right">
                                Odhadovaná<br/>chyba
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="HorizontalDistanceResidualList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@distance='*******'">
                                          <xsl:value-of select="@distance"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@estimatedError='*******'">
                                          <xsl:value-of select="@estimatedError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@estimatedError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@fromStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@toStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@distance='*******'">
                                          <xsl:value-of select="@distance"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@estimatedError='*******'">
                                          <xsl:value-of select="@estimatedError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@estimatedError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <xsl:for-each select="DistanceTotals">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">Vzdálenost RMS chyba = &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS chyba = &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Maximum vzdálenost zbytek &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="@fromStation"/>
                              </td>
                              <th align="center" nowrap="nowrap"> - &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="@toStation"/>
                              </td>
                              <th align="center" nowrap="nowrap"> z &#xa0;</th>
                              <td>
                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <xsl:for-each select="HorizontalAngleResidual">
                        <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">SMĚROVĚ ÚHEL ZBYTKY&#xa0;</th>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="70%">
                          <colgroup span="6">
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                            <col width="10%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Zpetná<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Osazená<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Dopředná<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="right">Angle</th>
                              <th class="underline" lang="en" align="right">
                                Residual<br/>(Sekundy)
                              </th>
                              <th class="underline" lang="en" align="right">Standardizovaný zbytek</th>
                              <th class="underline" lang="en" align="right">
                                Odhadovaná chyba<br/>(Sekundy)
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="HorizontalAngleResidualList">
                              <xsl:choose>
                                <xsl:when test="@isAsterisk='True'">
                                  <tr style="color:FF0000">
                                    <td align="left">
                                      <xsl:value-of select="@backSightStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@occupiedStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@foreSightStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@angle='*******'">
                                          <xsl:value-of select="@angle"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:angularFormat(number(@angle))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@estimatedError='*******'">
                                          <xsl:value-of select="@estimatedError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@estimatedError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="left">*</td>
                                  </tr>
                                </xsl:when>
                                <xsl:otherwise>
                                  <tr>
                                    <td align="left">
                                      <xsl:value-of select="@backSightStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@occupiedStation"/>
                                    </td>
                                    <td align="left">
                                      <xsl:value-of select="@foreSightStation"/>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@angle='*******'">
                                          <xsl:value-of select="@angle"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:angularFormat(number(@angle))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@residual='*******'">
                                          <xsl:value-of select="@residual"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@snoopError='*******'">
                                          <xsl:value-of select="@snoopError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                    <td align="right">
                                      <xsl:choose>
                                        <xsl:when test="@estimatedError='*******'">
                                          <xsl:value-of select="@estimatedError"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                          <xsl:value-of select="cif:distanceFormat(number(@estimatedError))"/>
                                        </xsl:otherwise>
                                      </xsl:choose>
                                    </td>
                                  </tr>
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <xsl:for-each select="AngleTotals">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">Úhel RMS chyba = &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@rmsError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Standardizovaný zbytek RMS chyba = &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@snoopError))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Maximální úhel zbytek &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="@backSightStation"/>
                              </td>
                              <th align="center" nowrap="nowrap"> - &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="@occupiedStation"/>
                              </td>
                              <th align="center" nowrap="nowrap"> - &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="@foreSightStation"/>
                              </td>
                              <th align="center" nowrap="nowrap"> z &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>

                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <xsl:for-each select="DoubleStub">
                        <table class="margin" cellpadding="1" cellspacing="1" width="20%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">DVOJITÝ ZBYTEK PRO STANICI:&#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="@station"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <colgroup span="6">
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Zpětná<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Obsazená<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="left">
                                Dopředná<br/>stanice
                              </th>
                              <th class="underline" lang="en" align="right">
                                Y<br/>chyba
                              </th>
                              <th class="underline" lang="en" align="right">
                                X<br/>chyba
                              </th>
                              <th class="underline" lang="en" align="right">
                                Délková<br/>chyba
                              </th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="DoubleStubList">
                              <tr>
                                <td align="left">
                                  <xsl:value-of select="@backSightStation"/>
                                </td>
                                <td align="left">
                                  <xsl:value-of select="@occupiedStation"/>
                                </td>
                                <td align="left">
                                  <xsl:value-of select="@foreSightStation"/>
                                </td>
                                <td align="right">
                                  <xsl:choose>
                                    <xsl:when test="//@northingError='*******'">
                                      <xsl:value-of select="@northingError"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="cif:distanceFormat(number(@northingError))"/>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </td>
                                <td align="right">
                                  <xsl:choose>
                                    <xsl:when test="//@eastingError='*******'">
                                      <xsl:value-of select="@eastingError"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="cif:distanceFormat(number(@eastingError))"/>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </td>
                                <td align="right">
                                  <xsl:choose>
                                    <xsl:when test="//@linearError='*******'">
                                      <xsl:value-of select="@linearError"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <xsl:value-of select="cif:distanceFormat(number(@linearError))"/>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>


                      <tr style="line-height:50%">
                        <td>&#xa0;</td>
                      </tr>
                      <xsl:for-each select="Traverse">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">VÝPIS UZAVŘENÍ TRASY&#xa0;</th>
                            </tr>
                            <tr style="line-height:50%">
                              <td>&#xa0;</td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Součet vzdáleností podél trasy je:&#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Uzavření v Y = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@closureInY))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Uzavření v X = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@closureInX))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Úhlové uzavření = &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:angularFormat(number(@angularClosure))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Délková chyba uzavření (po otočení) je &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@linearClosure))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Po otočení Přesnost je 1 / &#xa0;</th>
                              <td align="left" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@precision))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <colgroup span="5">
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                            <col width="5%"/>
                          </colgroup>
                          <thead style="display:table-header-group">
                            <tr>
                              <th class="underline" lang="en" align="left">Stanice</th>
                              <th class="underline" lang="en" align="right">Směrník</th>
                              <th class="underline" lang="en" align="right">Vzdálenost</th>
                              <th class="underline" lang="en" align="right">Y</th>
                              <th class="underline" lang="en" align="right">X</th>
                            </tr>
                          </thead>
                          <tbody>
                            <xsl:for-each select="TraverseList">
                              <tr>
                                <td align="left">
                                  <xsl:value-of select="@stationName"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:directionFormat(number(@bearing))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:distanceFormat(number(@distance))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                </td>
                                <td align="right">
                                  <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                </td>
                              </tr>
                            </xsl:for-each>
                          </tbody>
                        </table>
                      </xsl:for-each>
                      <xsl:for-each select="TraverseTotals">
                        <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                          <tbody>
                            <tr>
                              <th align="left" nowrap="nowrap">Celková délka vzdáleností trasy = &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                              </td>
                              <th>
                                <xsl:if test="//@linearUnits = 'I'">mil</xsl:if>
                                <xsl:if test="//@linearUnits = 'F'">mil</xsl:if>
                                <xsl:if test="//@linearUnits = 'M'">kilometrů</xsl:if>
                              </th>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Přesnost dle šířky a odchylky uzavření = 1 / &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@closure))"/>
                              </td>
                            </tr>
                            <tr>
                              <th align="left" nowrap="nowrap">Přesnost po korekci orientace = 1 / &#xa0;</th>
                              <td align="right" nowrap="nowrap">
                                <xsl:value-of select="cif:distanceFormat(number(@precision))"/>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </xsl:for-each>
                    </table>
                  </xsl:for-each>
                </xsl:for-each>
              </xsl:for-each>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>
  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
        Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje síť měření s provedeným vyrovnáním. </p>

      <p class="normal1">  V Průzkumníku projektu se ujistěte, že vpravo od Vyrovnání svítí zelená značka (ukazuje kompletní provedení). Pravým kliknutím na Vyrovnání vyberte Výsledky vyrovnání pro odpovídající výpis. </p>
      <p class="normal1"> Po otevření Průzkumníka výpisů zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
      <p class="small" lang="en">
        <em>&#xa9; 2012 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>
